REM **********************************************************************
REM THIS CODE AND INFORMATION IS PROVIDED TO YOU FOR YOUR REFERENTIAL 
REM PURPOSES ONLY, AND IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
REM EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED 
REM WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE, 
REM AND MAY NOT BE REDISTRIBUTED IN ANY MANNER.
REM 
REM Copyright (c) 2005  Microsoft Corporation.  All rights reserved.
REM **********************************************************************


@echo off
echo.
setlocal enabledelayedexpansion

REM ***                          ***
REM *** E-Mail User Provisioning ***
REM ***                          ***

if "%4"=="" goto ALT_ENTER

REM Setup the Environment Variables
set popUsername=%1
set domainName=%2
set altAddress=%3
set mailon=%4
goto SKIP_ALT_ENTER

:ALT_ENTER
REM Get User Input
set /p popUsername=Pop Username:
set /p domainName=Domain Name:
set /p altAddress=Current email:
set /p mailon=Mailon (y/n):
:SKIP_ALT_ENTER

REM Define the tempfile for the Password script
set password_tempfile=passtemp.tmp

REM *** Set password ***
REM Run the Pass.vbs script to create a Random Password (currently 8 Bytes long, you can easily change that in the script)
cscript //NOLOGO pass.vbs > %password_tempfile%

REM Read the tempfile and extract the Password
for /f %%i in (%password_tempfile%) do set password=%%i
set password=%password%1
echo Password: %password%
del %password_tempfile%

REM *** Add a new pop user ***
echo Adding POP User...
winpop add %popUsername%@%domainName% /createuser %password%
echo Errorlevel: %errorlevel%
if NOT %errorlevel%==0 goto END
echo Done.

REM ****************** Mail section ************************
if NOT "%mailon%"=="y" 	goto skip_mail
echo Sending mail...

REM Set the Email properties here
set Contact1=postmaster@%domainName%
set from=postmaster@%domainName%
set subject="Windows Server 2003 E-Mail Services"
set to2=%altAddress%
set to3=%Contact1%
set smarthost=localhost

REM *** Had to make sure body was surrounded by quotes and that all non-variable percent signs were escaped to percentpercent
set body1="<p><font face=Arial>Your <b>Windows Server 2003 E-Mail Services</b> request has been fulfilled for POP username: <span style="color:red"><b>%popUsername%</b></span>.</p><p>Please use the following information to access your account:<br><br><b>Username: </b><span style="color:green"><b>%popUsername%@%domainName%</b></span><i><font size="2"> (if using SPA just use <font color="green"><b>%popUsername%</b></font>)</font></i></b><br><b>Password: </b><span style="color:green"><b>%password%</b></span><br><b>Email address: </b><span style="color:green"><b>%popUsername%@%domainName%</b></span><br><b>POP Server:</b> <span style="color:green"><b>pop.%domainName%</b></span><br><b>SMTP Server: </b><span style="color:green"><b>smtp.%domainName%</b></span></p><p><b>NOTE:</b> You must authenticate against the SMTP server to send mail. In Outlook Express, this is done by checking the <b>&#39;My server requires authentication&#39;</b> in the &#39;Outgoing Sever&#39; section of your mail account properties.  In addition, the username you use to authenticate with against the SMTP server must only be your POP username (without <span style="color:green"><b>@%domainName%</b></span>).</font></p>"
set body2="<p>The requested <b>Windows Server 2003 E-Mail Services</b> have been provisioned for POP username: <span style='color:green'><b>%popUsername%</b></span>.  A confirmation email has been sent to <span style='color:green'><b>%popUsername%@%domainName%</b></span> and to <span style='color:green'><b>%altAddress%</b></span>.</font></p>"

cmdmail.vbs -t %to2% -f %from% -s %subject% -b %body1% -m %smarthost% -h html
cmdmail.vbs -t %to3% -f %from% -s %subject% -b %body2% -m %smarthost% -h html
echo Done sending mail.
:skip_mail
REM **********************************************************

:END

if "%4"=="" pause
	
endlocal